/*
 * ContagionStatistics.h
 *
 *  Created on: Nov 28, 2013
 *      Author: nino
 */

#ifndef CONTAGIONSTATISTICS_H_
#define CONTAGIONSTATISTICS_H_

#include <StandardLibs.h>
#include <NetworkStructure.h>
#include <Imports.h>
#include <ContagionModels.h>

typedef struct{
	long int no_of_iteration_per_cycle;
	long int no_of_init_cycles;

	// Forward statistics:
    igraph_matrix_t mean;
    igraph_matrix_t std;
    //igraph_matrix_t mean_range;
    //igraph_matrix_t std_range;
    //igraph_matrix_t range_int;

    double epsilon;
    //igraph_vector_t percent_recovered;
    //igraph_matrix_t ranges_from_start_node;
    //igraph_vector_t range_distribution;
    igraph_vector_t recovered_nodes;
    //igraph_vector_t relative_no_of_recovered;
    //igraph_vector_t relative_epidemic_range;
    //igraph_real_t diameter;

    //Inverse statistics
    igraph_vector_t * observed_realization = NULL;
    int diameter_inf_subgraph = -1;
    // Inverse statistics in collector process
    igraph_spmatrix_t * detectability_mat = NULL;
    igraph_spmatrix_t * detectability_mat_square = NULL;
    int det_matrix_is_normalized = 0;
    double * likelihoodAll = NULL;
    int realization_size = -1; //num of potencial candidates for which likelihood has been calculated

    //information for sensors: mask etc.
    int use_mask = 0; //default
    igraph_vector_t * mask = NULL;

    //statistics for LIKELIHOOD_METHOD_SOFT_MARGIN_A_RANGE estimator
    vector<double*> a_array_likelihoods; //pointers to likelihoods for specific a
    vector<double> a_array;

    // PROCESS properties
    SIMULATION_TYPE contagion_process_type;


    //Used in null models
    unsigned random_seed;




} statistics;

void init_statistic_parameters(const long int nrow, const long int ncol, input * input_args, infected_structure * p_infected_parameters, statistics *statistic_parameters);

void init_static_parameters_detectability(infected_structure * p_infected_parameters, statistics *statistic_parameters);

void destroy_statistic_parameters(statistics *statistic_parameters);

void update_detectability_matrices(statistics *statistic_parameters, double * likelihoodsAll, infected_structure * p_infected_parameters);

void print_detectabilty_matrix(statistics *statistic_parameters, infected_structure * p_infected_parameters);

void print_E_V_detectabilty_matrix_diagonal(statistics *statistic_parameters, vector<int> * source_array_id);

void normalize_detectabilty_matrix(statistics *statistic_parameters, int num_real_per_source);

double get_detectability_element(statistics *statistic_parameters, long int node_i, long int node_j);

double get_detectability_VAR_element(statistics *statistic_parameters, long int node_i, long int node_j);

void print_detectabilty_matrix_VAR(statistics *statistic_parameters, infected_structure * p_infected_parameters);

void update_detectability_matrices_by_def(statistics *statistic_parameters, double * likelihoodsAll, infected_structure * p_infected_parameters);

void free_mask_in_statistics_struct(statistics * statistic_parameters);

#endif /* CONTAGIONSTATISTICS_H_ */
